<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Unite extends Model 
{

    protected $table = 'unites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'id_entreprise', 'valeur', 'abreviation', 'description', 'statut');
    protected $visible = array('slug', 'id_entreprise', 'valeur', 'abreviation', 'description', 'statut');

    public function aliment()
    {
        return $this->hasMany('App\Models\Aliment', 'id_unite');
    }

    public function mouvementStock()
    {
        return $this->hasMany('App\Models\MouvementStock', 'id_unite');
    }

    public function equivalence()
    {
        return $this->hasMany('App\Models\EquivalenceUnite', 'id_uniteDepart');
    }

    public function entreprise()
    {
        return $this->belongsTo('App\Models\Entreprise', 'id_entreprise');
    }

    public function AlimentUniteSortie()
    {
        return $this->hasMany('App\Models\Aliment', 'unite_sortie');
    }

}